package ru.yandex.sanitizer2.config;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.server.ImmutableBaseServerConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableSanitizer2Config
    extends ImmutableBaseServerConfig
    implements Sanitizer2Config
{
    private final PatternMap<RequestInfo, ImmutableSanitizingConfig> sanitizers;

    public ImmutableSanitizer2Config(final Sanitizer2Config config)
        throws ConfigException
    {
        super(config);
        sanitizers =
            config.sanitizers().transform(ImmutableSanitizingConfig::new);
    }

    @Override
    public PatternMap<RequestInfo, ImmutableSanitizingConfig> sanitizers() {
        return sanitizers;
    }
}

