package ru.yandex.sanitizer2.config;

import java.util.function.Predicate;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.sanitizer2.UrlType;

public class ImmutableUrlConfig implements UrlConfig {
    private final UrlType type;
    private final boolean image;
    private final Predicate<String> allowedHosts;

    public ImmutableUrlConfig(final UrlConfig config) throws ConfigException {
        type = TYPE.validate(config.type());
        image = IMAGE.validate(config.image());
        allowedHosts = ALLOWED_HOSTS.validate(config.allowedHosts());
    }

    @Override
    public UrlType type() {
        return type;
    }

    @Override
    public boolean image() {
        return image;
    }

    @Override
    public Predicate<String> allowedHosts() {
        return allowedHosts;
    }
}

