package ru.yandex.sanitizer2.config;

import java.util.HashMap;
import java.util.Map;

public class Interner {
    private final Map<String, String> tags = new HashMap<>();
    private final Map<String, String> attrs = new HashMap<>();
    private final Map<String, String> properties = new HashMap<>();

    @SuppressWarnings("ReferenceEquality")
    private static void add(
        final Map<String, String> map,
        final String value,
        final String type)
    {
        String old = map.put(value, value);
        if (old != null && old != value) {
            throw new IllegalStateException(
                type + " not interned properly: " + value);
        }
    }

    public void addTag(final String tag) {
        add(tags, tag, "Tag");
    }

    public void addAttr(final String attr) {
        add(attrs, attr, "Attribute");
    }

    public void addProperty(final String property) {
        add(properties, property, "Property");
    }

    public String internTag(final String tag) {
        return tags.get(tag);
    }

    public String internAttr(final String attr) {
        return attrs.get(attr);
    }

    public String internProperty(final String property) {
        return properties.get(property);
    }
}

