package ru.yandex.sanitizer2.config;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.sanitizer2.PageHeaderPredicateType;

public interface PageHeaderConfig {
    ParameterConfig<PageHeaderPredicateType> TYPE =
        new ParameterConfig<>(
            "type",
            new EnumParser<>(PageHeaderPredicateType.class),
            GenericFunction.identity());
    ParameterConfig<String> CONTENT = new ParameterConfig<>(
        "content",
        GenericFunction.identity(),
        GenericFunction.identity());
    ParameterConfig<String> HEADER = new ParameterConfig<>(
        "header-file",
        PageHeaderConfig::readFile,
        GenericFunction.identity());
    ParameterConfig<String> FOOTER = new ParameterConfig<>(
        "footer-file",
        PageHeaderConfig::readFile,
        GenericFunction.identity());

    static String readFile(final String path) throws IOException {
        return new String(
            Files.readAllBytes(Paths.get(path)),
            StandardCharsets.UTF_8);
    }

    // Content type, regex pattern or substring
    PageHeaderPredicateType type();

    // If input matches content, then add header and footer to the result
    String content();

    // Header itself
    String header();

    // Footer itself
    String footer();
}

