package ru.yandex.sanitizer2.config;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyCollectionValidator;
import ru.yandex.parser.string.NonEmptyValidator;

public interface PropertyAliasConfig {
    ParameterConfig<Set<String>> NAMES = new ParameterConfig<>(
        "names",
        new CollectionParser<>(NonEmptyValidator.TRIMMED, LinkedHashSet::new),
        NonEmptyCollectionValidator.instance());
    ParameterConfig<String> DEFAULT_VALUE = new ParameterConfig<>(
        "default-value",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.TRIMMED),
        true);
    ParameterConfig<Boolean> TERMINAL = new ParameterConfig<>(
        "terminal",
        BooleanParser.INSTANCE,
        GenericFunction.identity());

    // List of properties to be created with value of this alias
    Set<String> names();

    // Default value if this property is missing or null
    String defaultValue();

    // Indicates that no other shorthand property expansions should be
    // performed if this property alias is matched
    boolean terminal();
}

