package ru.yandex.sanitizer2.config;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.StringLengthValidator;

public interface PropertyFoldConfig {
    ParameterConfig<String> DEFAULT_VALUE = new ParameterConfig<>(
        "default-value",
        GenericFunction.identity(),
        GenericFunction.identity(),
        true);
    ParameterConfig<Boolean> MANDATORY = new ParameterConfig<>(
        "mandatory",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Character> SEPARATOR = new ParameterConfig<>(
        "separator",
        new StringLengthValidator(1).andThen(x -> x.charAt(0)),
        GenericFunction.identity());
    ParameterConfig<Boolean> ALLOW_SPACES = new ParameterConfig<>(
        "allow-spaces",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> ALLOW_COMMAS = new ParameterConfig<>(
        "allow-commas",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<String> REQUIRED_PROPERTY = new ParameterConfig<>(
        "required-property",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.TRIMMED),
        true);

    // Default value, which can be skipped when folding
    // If null, then this property is mandatory and no folding should be done
    // if this property is missing
    String defaultValue();

    // Explicitly indicates that this property is mandatory, but have default
    // value, so this value will be eradicated when folding
    boolean mandatory();

    // Special separator which will be added before this property value
    // For example: font: font-size / line-height font-family
    // By default all values separated with space
    char separator();

    // If spaces not allowed to present in value, do not fold
    // Actual for double folding for border property etc.
    boolean allowSpaces();

    // If commas not allowed to present in value, do not fold
    // Actual for multiple background-image folding.
    boolean allowCommas();

    // Do not fold if the following property is missing
    // May be null, if no such property required
    String requiredProperty();
}

