package ru.yandex.sanitizer2.config;

import java.util.Map;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;

public interface PropertyFoldsConfig {
    ParameterConfig<Boolean> FOLD_ALL_EQUAL = new ParameterConfig<>(
        "fold-all-equal",
        BooleanParser.INSTANCE,
        GenericFunction.identity());

    // If all folded properties have same value, replace fold with single value
    boolean foldAllEqual();

    // Expanded shorthand property folding config
    // If all mandatory (with null default values) properties present, then
    // these properties and optional ones can be compacted into single property
    Map<String, ? extends PropertyFoldConfig> properties();
}

