package ru.yandex.sanitizer2.config;

import java.net.URI;
import java.util.function.Predicate;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.HostnamePredicateParser;
import ru.yandex.parser.string.URIParser;

public interface ResizerConfig {
    ParameterConfig<URI> RESIZER_URI = new ParameterConfig<>(
        "uri",
        URIParser.FRAGMENT_STRIPPING,
        GenericFunction.identity());
    ParameterConfig<String> SALT = new ParameterConfig<>(
        "salt",
        GenericFunction.identity(),
        GenericFunction.identity());
    ParameterConfig<Predicate<String>> WHITELIST_HOSTS = new ParameterConfig<>(
        "whitelist-hosts",
        HostnamePredicateParser.INSTANCE,
        GenericFunction.identity());

    // Resizer base uri
    URI uri();

    // Resizer hash salt
    String salt();

    // Domains which links should be left untouched
    // If domain starts with '.', then all subdomains considered whitelisted
    Predicate<String> whitelistHosts();
}

