package ru.yandex.sanitizer2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class Sanitizer2ConfigBuilder
    extends AbstractSanitizer2ConfigBuilder<Sanitizer2ConfigBuilder>
{
    public Sanitizer2ConfigBuilder() {
        super(Sanitizer2ConfigDefaults.INSTANCE);
    }

    public Sanitizer2ConfigBuilder(final Sanitizer2Config config) {
        super(config);
    }

    public Sanitizer2ConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, Sanitizer2ConfigDefaults.INSTANCE);
    }

    public Sanitizer2ConfigBuilder(
        final IniConfig config,
        final Sanitizer2Config defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public Sanitizer2ConfigBuilder self() {
        return this;
    }

    public ImmutableSanitizer2Config build() throws ConfigException {
        return new ImmutableSanitizer2Config(this);
    }
}

