package ru.yandex.sanitizer2.config;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.server.BaseServerConfigDefaults;
import ru.yandex.logger.AccessLoggerConfigDefaults;
import ru.yandex.logger.LoggersConfig;
import ru.yandex.logger.LoggersConfigBuilder;

public class Sanitizer2ConfigDefaults
    extends BaseServerConfigDefaults
    implements Sanitizer2Config
{
    public static final Sanitizer2ConfigDefaults INSTANCE =
        new Sanitizer2ConfigDefaults();

    private static final LoggersConfig LOGGERS_CONFIG =
        new LoggersConfigBuilder(BaseServerConfigDefaults.INSTANCE.loggers())
            .accessLoggers(
                new PatternMap<>(
                    new Sanitizer2AccessLoggerConfigDefaults()));

    protected Sanitizer2ConfigDefaults() {
    }

    @Override
    public String name() {
        return "Sanitizer2";
    }

    @Override
    public PatternMap<RequestInfo, ? extends SanitizingConfig> sanitizers() {
        return new PatternMap<>(SanitizingConfigDefaults.INSTANCE);
    }

    @Override
    public LoggersConfig loggers() {
        return LOGGERS_CONFIG;
    }

    private static class Sanitizer2AccessLoggerConfigDefaults
        extends AccessLoggerConfigDefaults
    {
        @Override
        public String logFormat() {
            return super.logFormat() + " %{http_content_length}";
        }
    }
}

