package ru.yandex.sanitizer2.config;

import java.util.Map;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;

public interface SanitizingConfig {
    ParameterConfig<Boolean> TEXT_URLENCODED = new ParameterConfig<>(
        "text-urlencoded",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> PRESERVE_DOUBLE_BRACES = new ParameterConfig<>(
        "preserve-double-braces",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> COMPLEX_CSS_MATCHING = new ParameterConfig<>(
        "complex-css-matching",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> FOLD_PROPERTIES = new ParameterConfig<>(
        "fold-properties",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> DETECT_PHISHING_HOSTS = new ParameterConfig<>(
        "detect-phishing-hosts",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> WRAP_PLAIN_LINKS = new ParameterConfig<>(
        "wrap-plain-links",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> COMPACT_HTML = new ParameterConfig<>(
        "compact-html",
        BooleanParser.INSTANCE,
        GenericFunction.identity());

    // Common options for urls sanitizing
    UrlSanitizingConfig urlSanitizingConfig();

    // Request text is urlencoded and stored in `text=` parameter, like:
    // text=%3cdiv%3e--%c2%a0%3c%2fdiv%3e
    boolean textUrlencoded();

    // Preserve double braces like '{{'
    // If false (which is default) replace with '{\u200b{' for attrs and
    // '{<!-- -->{' for text
    // By default we are trying to break double braces, so sanitized HTML can't
    // be modified by template languages like Angular
    boolean preserveDoubleBraces();

    // Support complex css selectors, like 'div.cls1.cls2#id#id > a.cls3 b'
    boolean complexCssMatching();

    // Support shorthand properties folding, like
    // 'background-position:center;background-size:300px 100px'
    // to
    // 'background:center / 300px 100px'
    boolean foldProperties();

    // check url hostname for phishing characters substitution, as described
    // in task DARIA-64178
    // on phishing detect, set url type to 5 instead of 3
    boolean detectPhishingHosts();

    // check text inside tag for plain links, create <a href="..."> if found
    boolean wrapPlainLinks();

    // try compact html after sanitizing
    boolean compactHtml();

    // Globally allowed attributes which can present on any tag.
    // For example "id", "class" or "style".
    Map<String, ? extends PropertyConfig> globalAttrs();

    // Allowed tags. All other tags will be discarded
    Map<String, ? extends TagConfig> tags();

    // Allowed CSS properties. All other properties will be discarded
    Map<String, ? extends PropertyConfig> style();

    // CSS properties shorthands. Split value into several CSS properties
    Map<String, ? extends ShorthandPropertyConfig> shorthands();

    // Page headers. Match content against predicate and put page header at
    // start of output if matched
    Map<String, ? extends PageHeaderConfig> pageHeaders();
}

