package ru.yandex.sanitizer2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class SanitizingConfigBuilder
    extends AbstractSanitizingConfigBuilder<SanitizingConfigBuilder>
{
    public SanitizingConfigBuilder() {
        super(SanitizingConfigDefaults.INSTANCE);
    }

    public SanitizingConfigBuilder(final SanitizingConfig config) {
        super(config);
    }

    public SanitizingConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, SanitizingConfigDefaults.INSTANCE);
    }

    public SanitizingConfigBuilder(
        final IniConfig config,
        final SanitizingConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public SanitizingConfigBuilder self() {
        return this;
    }

    public ImmutableSanitizingConfig build() throws ConfigException {
        return new ImmutableSanitizingConfig(this);
    }
}

