package ru.yandex.sanitizer2.config;

import java.util.Collections;
import java.util.Map;

public class SanitizingConfigDefaults implements SanitizingConfig {
    public static final SanitizingConfigDefaults INSTANCE =
        new SanitizingConfigDefaults();

    protected SanitizingConfigDefaults() {
    }

    @Override
    public UrlSanitizingConfig urlSanitizingConfig() {
        return UrlSanitizingConfigDefaults.INSTANCE;
    }

    @Override
    public boolean textUrlencoded() {
        return false;
    }

    @Override
    public boolean preserveDoubleBraces() {
        return false;
    }

    @Override
    public boolean complexCssMatching() {
        return true;
    }

    @Override
    public boolean foldProperties() {
        return true;
    }

    @Override
    public boolean detectPhishingHosts() {
        return false;
    }

    @Override
    public boolean wrapPlainLinks() {
        return false;
    }

    @Override
    public boolean compactHtml() {
        return true;
    }

    @Override
    public Map<String, PropertyConfig> globalAttrs() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, TagConfig> tags() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, PropertyConfig> style() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, ShorthandPropertyConfig> shorthands() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, PageHeaderConfig> pageHeaders() {
        return Collections.emptyMap();
    }
}

