package ru.yandex.sanitizer2.config;

import java.util.Map;
import java.util.regex.Pattern;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;

// CSS shorthand property config
public interface ShorthandPropertyConfig {
    ParameterConfig<Boolean> INHERITED = new ParameterConfig<>(
        "inherited",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Pattern> PATTERN = new ParameterConfig<>(
        "pattern",
        Pattern::compile,
        GenericFunction.identity());

    // Indicates that this property inherited by nested elements but can be
    // overwritten without side effects
    // If value is missing, corresponding shorthand property cannot be folded
    boolean inherited();

    // Shorthand splitting pattern, contains capturing named groups for
    // sub-properties
    Pattern pattern();

    // Maps capturing named group to CSS property name and its default value
    Map<String, ? extends PropertyAliasConfig> properties();

    // Expanded shorthand property folding config
    PropertyFoldsConfig foldsConfig();
}

