package ru.yandex.sanitizer2.config;

import java.util.Map;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.config.SectionConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.NonEmptyValidator;

public interface TagConfig {
    ParameterConfig<String> RENAME_TO = new ParameterConfig<>(
        "rename-to",
        GenericFunction.identity(),
        new NullToDefaultFunction<>(NonEmptyValidator.TRIMMED),
        true);
    ParameterConfig<Boolean> REQUIRE_CONTENT = new ParameterConfig<>(
        "require-content",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> REQUIRE_ATTRS = new ParameterConfig<>(
        "require-attrs",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> COMBINE = new ParameterConfig<>(
        "combine",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> FLAG = new ParameterConfig<>(
        "flag",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> IGNORE_SELF_CLOSE = new ParameterConfig<>(
        "ignore-self-close",
        BooleanParser.INSTANCE,
        GenericFunction.identity());

    static SectionConfig<
        PropertyConfig,
        ImmutablePropertyConfig,
        PropertyConfigBuilder>
    attributeConfigParser(
        final String name,
        final ImmutableUrlSanitizingConfig urlSanitizingConfig)
    {
        return new SectionConfig<>(
            name,
            PropertyConfigBuilder::new,
            config -> new ImmutablePropertyConfig(
                config,
                urlSanitizingConfig,
                true));
    }

    // If non-null, rename tag to specified one
    // Renaming is performed at HTML printing stage, so style selectors applied
    // to original tag and attrs will be validated for original tag
    String renameTo();

    // Skip tag if it has not child nodes
    // For example: "<i>text<i><p></p>" will become just "<i>text<i>"
    boolean requireContent();

    // Skip tag if no attributes left after sanitizing
    // For example: "<a><b>text</b></a>" will become just "<b>text</b>"
    boolean requireAttrs();

    // Combine attrs if parent tag has same name and no other childs
    // Has no effect if both tags has style with non-combinable properties
    // like "border-style" or "display"
    // For example:
    //  <font family="verdana"><font size="2">text</font></font>
    // will become:
    //  <font family="verdana" size="2">text</font>
    boolean combine();

    // This tag turns some flag on block, for example: <b>, <i>, <u> etc.
    // Several flag following each other can be reordered and duplicate tags
    // can be collapsed. For example:
    //  <b><i><b><i>text</i></b></i></b>
    // will become just:
    //  <b><i>text</i></b>
    // flag implies combine
    boolean flag();

    // Ignore self close for this tag, like <a href="..."/>link</a>
    boolean ignoreSelfClose();

    // Attributes allowed for this tag, all other attributes will be discarded
    Map<String, ? extends PropertyConfig> attrs();
}

