package ru.yandex.sanitizer2.config;

import java.util.function.Predicate;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.HostnamePredicateParser;
import ru.yandex.sanitizer2.UrlType;

// Common config for attribute and css-properties values validation
public interface UrlConfig {
    ParameterConfig<UrlType> TYPE = new ParameterConfig<>(
        "type",
        new EnumParser<>(UrlType.class),
        GenericFunction.identity());
    ParameterConfig<Boolean> IMAGE = new ParameterConfig<>(
        "image",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Predicate<String>> ALLOWED_HOSTS = new ParameterConfig<>(
        "allowed-hosts",
        HostnamePredicateParser.INSTANCE,
        GenericFunction.identity());

    // url type
    UrlType type();

    // Indicates that this url should be wrapped with resizer
    boolean image();

    // Check url hostname against list of allowed hosts
    // Erase attribute on failure
    Predicate<String> allowedHosts();
}

