package ru.yandex.sanitizer2.config;

import java.util.function.Predicate;

import ru.yandex.function.TruePredicate;
import ru.yandex.sanitizer2.UrlType;

public class UrlConfigDefaults implements UrlConfig {
    public static final UrlConfigDefaults INSTANCE = new UrlConfigDefaults();

    protected UrlConfigDefaults() {
    }

    @Override
    public UrlType type() {
        return UrlType.AUTO;
    }

    @Override
    public boolean image() {
        return false;
    }

    @Override
    public Predicate<String> allowedHosts() {
        return TruePredicate.instance();
    }
}

