package ru.yandex.sanitizer2.config;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;

public interface UrlSanitizingConfig {
    ParameterConfig<Boolean> FORCE_HTTPS = new ParameterConfig<>(
        "force-https",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> UNPROXY = new ParameterConfig<>(
        "unproxy",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> ALLOW_RELATIVE_URLS = new ParameterConfig<>(
        "allow-relative-urls",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Set<String>> BYPASS_SCHEMES = new ParameterConfig<>(
        "bypass-schemes",
        new CollectionParser<>(NonEmptyValidator.TRIMMED, HashSet::new),
        GenericFunction.identity());
    ParameterConfig<Set<String>> ALLOWED_SCHEMES = new ParameterConfig<>(
        "allowed-schemes",
        new CollectionParser<>(NonEmptyValidator.TRIMMED, HashSet::new),
        GenericFunction.identity());
    ParameterConfig<Boolean> JSON_MARKUP = new ParameterConfig<>(
        "json-markup",
        BooleanParser.INSTANCE,
        GenericFunction.identity());
    ParameterConfig<Boolean> DROP_PATH_AND_QUERY = new ParameterConfig<>(
        "drop-path-and-query",
        BooleanParser.INSTANCE,
        GenericFunction.identity());


    // Resizer configuration, may be null
    ResizerConfig resizerConfig();

    // Rewrite image links to be https
    boolean forceHttps();

    // Unwrap resizer links
    boolean unproxy();

    // Do not force scheme and host for URIs which doesn't have them
    boolean allowRelativeUrls();

    // Bypass urls with these schemes without rewriting
    Set<String> bypassSchemes();

    // Allow urls with these schemes
    // All urls with schemes other than allowed or bypassed, will be erased
    Set<String> allowedSchemes();

    // Provide multipart response with URLs markup in json format
    boolean jsonMarkup();

    // Hidereferer configuration
    // See https://wiki.yandex-team.ru/intranet/hidereferer/ for details
    HiderefererConfig hiderefererConfig();


    // Remove parts, as they may contain user-specific data and be noisy
    // Logic is decoupled from FastUri
    boolean dropPathAndQuery();
}

