#!/bin/bash
set -exo pipefail

source recommended_java_args.sh

export SANITIZER2_PORT=443
export SANITIZER2_HTTP_PORT=$BSCONFIG_IPORT

export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | gawk '{print int($1*0.6)}')
export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')

if [ "$LABELS_deploy_engine" = "YP_LITE" ]; then
    export MEMORY_LIMIT=$(echo $MEM_LIMIT | gawk '{print int($1*0.6)}')
    export CPU_CORES=$(echo $CPU_LIMIT | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
fi

if [ $CPU_CORES -lt 6 ]
then
    export CPU_CORES=6
fi

case "$NANNY_SERVICE_ID" in
    ps_sanitizer_test*)
        export SERVER_NAME=sanitizer-test.pers.yandex.net
        export LOGROTATE_DAYS=1
        ;;
    ps_sanitizer_yp*)
        export SERVER_NAME=sanitizer2.mail.yandex.net
        export LOGROTATE_DAYS=2
        ;;
    ps_sanitizer*)
        export SERVER_NAME=sanitizer2.mail.yandex.net
        export LOGROTATE_DAYS=7
        ;;
esac

