#!/bin/bash
set -exo pipefail

source config.sh

source classpath.sh

MEM_ARGS="-Xmx$MEMORY_LIMIT -Xms256M -Xmaxf0.2 -Xminf0.1 -Xmine32M -Xmaxe64M -Xloa -Xloainitial0.2 -Xss8m"
GC_ARGS="-Xgcpolicy:gencon -verbose:gc -Xgcthreads4 -Xconcurrentbackground2 -Xconcurrentlevel4 -Xgc:concurrentMark -Xgc:concurrentScavengeBackground=1 -Xgc:concurrentScavenge -XX:IdleTuningGcOnIdle -XX:IdleTuningMinIdleWaitTime=1 -Xgc:maxScavengeBeforeGlobal=20 -Xaggressive -Xgc:minContractPercent=2 -Xgc:maxContractPercent=5 -Xverbosegclog:/dev/shm/gc#.log,5,2000"
ADDITIONAL_ARGS="-XX:ActiveProcessorCount=$CPU_CORES"
SANITIZER2_ARGS="ru.yandex.sanitizer2.Sanitizer2 sanitizer2_https.conf"
LD_LIBRARY_PATH=$JAVA_LD_LIBRARY_PATH LD_PRELOAD=$JAVA_LD_PRELOAD exec \
    $BSCONFIG_IDIR/jdk/bin/java \
    -DPORTO=1 \
    $JAVA_ARGS $MEM_ARGS $GC_ARGS $ADDITIONAL_ARGS \
    -Djava.library.path=sanitizer_service \
    -cp $CLASSPATH $SANITIZER2_ARGS
