package ru.yandex.http.server.async;

import java.net.SocketException;
import java.nio.channels.SocketChannel;

import ru.yandex.function.GenericAutoCloseable;

public class ActiveConnection {
    private final SocketChannel channel;
    private final GenericAutoCloseable<RuntimeException> resourcesReleaser;
    private volatile boolean closed = false;

    public ActiveConnection(
        final SocketChannel channel,
        final GenericAutoCloseable<RuntimeException> resourcesReleaser)
    {
        this.channel = channel;
        this.resourcesReleaser = resourcesReleaser;
    }

    public SocketChannel channel() {
        return channel;
    }

    private void releaseResources() {
        closed = true;
        if (resourcesReleaser != null) {
            resourcesReleaser.close();
        }
    }

    public void connectionEvicted() {
        releaseResources();
    }

    public void markClosed() {
        releaseResources();
    }

    public void markShutdowned() {
        releaseResources();
        try {
            channel.socket().setSoLinger(true, 0);
        } catch (SocketException e) {
            // ignore
        }
    }

    public boolean isClosed() {
        return closed || !channel.isOpen();
    }
}

