package ru.yandex.http.server.async;

import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.parser.config.IniConfig;

public abstract class AlertsConfigHandlerBase
    implements HttpAsyncRequestHandler<HttpRequest>
{
    protected void handle(
        final HttpAsyncExchange exchange,
        final IniConfig alertsConfig)
    {
        exchange.getResponse().setEntity(
            new NStringEntity(
                alertsConfig.toString(),
                ContentType.TEXT_PLAIN));
        exchange.submitResponse();
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }
}

