package ru.yandex.http.server.async;

import org.apache.http.Header;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerMapper;

import ru.yandex.http.util.request.RequestHandlerMapper;

public class CompositeHttpAsyncRequestHandlerMapper
    extends RequestHandlerMapper<HttpAsyncRequestHandler<?>>
    implements HttpAsyncRequestHandlerMapper
{
    @Override
    public HttpAsyncRequestHandler<?> dummyHandler(
        final int statusCode,
        final String body)
    {
        return new DummyHttpAsyncRequestHandler(statusCode, body);
    }

    @Override
    public HttpAsyncRequestHandler<?> dummyHandler(
        final int statusCode,
        final String body,
        final Header header)
    {
        return new DummyHttpAsyncRequestHandler(statusCode, body, header);
    }

    @Override
    public HttpAsyncRequestHandler<?> dummyHandler(
        final int statusCode,
        final String body,
        final Header... headers)
    {
        return new DummyHttpAsyncRequestHandler(statusCode, body, headers);
    }
}

