package ru.yandex.http.server.async;

import java.net.InetSocketAddress;

import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.reactor.IOSession;

public class ConditionalNHttpServerConnectionFactory
    implements NHttpConnectionFactory<LoggingNHttpServerConnection>
{
    private final int httpPort;
    private final NHttpServerConnectionFactory httpConnectionFactory;
    private final NHttpServerConnectionFactory httpsConnectionFactory;

    public ConditionalNHttpServerConnectionFactory(
        final int httpPort,
        final NHttpServerConnectionFactory httpConnectionFactory,
        final NHttpServerConnectionFactory httpsConnectionFactory)
    {
        this.httpPort = httpPort;
        this.httpConnectionFactory = httpConnectionFactory;
        this.httpsConnectionFactory = httpsConnectionFactory;
    }

    @Override
    public LoggingNHttpServerConnection createConnection(
        final IOSession session)
    {
        InetSocketAddress address =
            (InetSocketAddress) session.getLocalAddress();
        if (address.getPort() == httpPort) {
            return httpConnectionFactory.createConnection(session);
        } else {
            return httpsConnectionFactory.createConnection(session);
        }
    }
}

