package ru.yandex.http.server.async;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.server.HttpServer;

public class CustomAlertsConfigHandler extends AlertsConfigHandlerBase {
    private final HttpServer<?, ?> server;

    public CustomAlertsConfigHandler(final HttpServer<?, ?> server) {
        this.server = server;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        handle(exchange, server.customAlerts(request));
    }

    @Override
    public String toString() {
        return "Prints custom server alerts config";
    }
}

