package ru.yandex.http.server.async;

import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

public class DisablePingHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final Runnable pingDisabler;

    public DisablePingHandler(final Runnable pingDisabler) {
        this.pingDisabler = pingDisabler;
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
    {
        pingDisabler.run();
        exchange.getResponse().setStatusCode(HttpStatus.SC_OK);
        exchange.submitResponse();
    }

    @Override
    public String toString() {
        return "Disables /ping requests handling";
    }
}
