package ru.yandex.http.server.async;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.FakeAsyncConsumer;

public class DummyHttpAsyncRequestHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private static final Header[] EMPTY_HEADERS = new Header[0];

    private final int statusCode;
    private final String body;
    private final Header[] headers;

    public DummyHttpAsyncRequestHandler(
        final int statusCode,
        final String body)
    {
        this.statusCode = statusCode;
        this.body = body;
        headers = EMPTY_HEADERS;
    }

    public DummyHttpAsyncRequestHandler(
        final int statusCode,
        final String body,
        final Header header)
    {
        this.statusCode = statusCode;
        this.body = body;
        headers = new Header[] {header};
    }

    public DummyHttpAsyncRequestHandler(
        final int statusCode,
        final String body,
        final Header... headers)
    {
        this.statusCode = statusCode;
        this.body = body;
        if (headers.length == 0) {
            this.headers = EMPTY_HEADERS;
        } else {
            this.headers = headers.clone();
        }
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        HttpResponse response = exchange.getResponse();
        response.setStatusCode(statusCode);
        if (body != null) {
            response.setEntity(
                new NStringEntity(
                    body,
                    CharsetUtils.acceptedCharset(request)));
        }
        for (Header header: headers) {
            response.addHeader(header);
        }
        exchange.submitResponse();
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }
}

