package ru.yandex.http.server.async;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.server.IBMDumper;

public class DumpHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private final IBMDumper dumper;

    public DumpHandler(final IBMDumper dumper) {
        this.dumper = dumper;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        dumper.process(request, context);
        exchange.submitResponse();
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public String toString() {
        return "Uses IBM JVM API to produce various process dumps";
    }
}

