package ru.yandex.http.server.async;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

import ru.yandex.http.util.server.AbstractConfigUpdateHandler;
import ru.yandex.logger.PrefixedLogger;

public class DynamycConfigUpdateHandler
    extends AbstractConfigUpdateHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    public DynamycConfigUpdateHandler(final BaseAsyncServer<?> server) {
        super(server);
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        PrefixedLogger logger =
            HttpCoreContext.adapt(context).getAttribute(
                BaseAsyncServer.LOGGER,
                PrefixedLogger.class);

        exchange.getResponse().setEntity(handle(request, logger));
        exchange.submitResponse();
    }
}
