package ru.yandex.http.server.async;

import java.net.SocketAddress;
import java.nio.channels.ByteChannel;

import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionBufferStatus;

public class FilterIOSession implements IOSession {
    protected final IOSession session;

    public FilterIOSession(final IOSession session) {
        this.session = session;
    }

    @Override
    public ByteChannel channel() {
        return session.channel();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return session.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return session.getLocalAddress();
    }

    @Override
    public int getEventMask() {
        return session.getEventMask();
    }

    @Override
    public void setEventMask(final int ops) {
        session.setEventMask(ops);
    }

    @Override
    public void setEvent(final int op) {
        session.setEvent(op);
    }

    @Override
    public void clearEvent(final int op) {
        session.clearEvent(op);
    }

    @Override
    public void close() {
        session.close();
    }

    @Override
    public void shutdown() {
        session.shutdown();
    }

    @Override
    public int getStatus() {
        return session.getStatus();
    }

    @Override
    public boolean isClosed() {
        return session.isClosed();
    }

    @Override
    public int getSocketTimeout() {
        return session.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(final int timeout) {
        session.setSocketTimeout(timeout);
    }

    @Override
    public void setBufferStatus(final SessionBufferStatus status) {
        session.setBufferStatus(status);
    }

    @Override
    public boolean hasBufferedInput() {
        return session.hasBufferedInput();
    }

    @Override
    public boolean hasBufferedOutput() {
        return session.hasBufferedOutput();
    }

    @Override
    public void setAttribute(final String name, final Object obj) {
        session.setAttribute(name, obj);
    }

    @Override
    public Object getAttribute(final String name) {
        return session.getAttribute(name);
    }

    @Override
    public Object removeAttribute(final String name) {
        return session.removeAttribute(name);
    }

    @Override
    public String toString() {
        return session.toString();
    }
}

