package ru.yandex.http.server.async;

import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.nio.FakeAsyncConsumer;

public class ForceGcHandler implements HttpAsyncRequestHandler<HttpRequest> {
    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
    {
        System.gc();
        exchange.submitResponse();
    }

    @Override
    public String toString() {
        return "Force GC";
    }
}

