package ru.yandex.http.server.async;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.ScanningCgiParams;

public abstract class GolovanPanelHandlerBase
    implements HttpAsyncRequestHandler<HttpRequest>
{
    protected void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final JsonValue golovanPanel)
        throws HttpException, IOException
    {
        Charset charset = CharsetUtils.acceptedCharset(request);
        CharsetEncoder encoder = charset.newEncoder()
            .onMalformedInput(CodingErrorAction.REPLACE)
            .onUnmappableCharacter(CodingErrorAction.REPLACE);
        DecodableByteArrayOutputStream baos =
            new DecodableByteArrayOutputStream();
        try (JsonWriter writer = JsonTypeExtractor.HUMAN_READABLE
                .extract(new ScanningCgiParams(request))
                .create(new OutputStreamWriter(baos, encoder)))
        {
            golovanPanel.writeValue(writer);
        }
        exchange.getResponse().setEntity(
            baos.processWith(
                new NByteArrayEntityFactory(
                    ContentType.APPLICATION_JSON.withCharset(charset))));
        exchange.submitResponse();
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public String toString() {
        return "Prints server metrics golovan panel";
    }
}

