package ru.yandex.http.server.async;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.server.HttpServer;

public class LogRotateHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpServer<?, HttpAsyncRequestHandler<?>> server;

    public LogRotateHandler(
        final HttpServer<?, HttpAsyncRequestHandler<?>> server)
    {
        this.server = server;
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        server.rotateLogs(context);
        exchange.getResponse().setEntity(
            new NStringEntity("logs rotated", ContentType.TEXT_PLAIN));
        exchange.submitResponse();
    }

    @Override
    public String toString() {
        return "Performs logs rotation";
    }
}

