package ru.yandex.http.server.async;

import java.util.logging.Logger;

import org.apache.http.HttpResponse;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

public class LoggingConnectionReuseStrategy
    extends DefaultConnectionReuseStrategy
{
    private final Logger logger;

    public LoggingConnectionReuseStrategy(final Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean keepAlive(
        final HttpResponse response,
        final HttpContext context)
    {
        LoggingNHttpServerConnection conn =
            (LoggingNHttpServerConnection) context.getAttribute(
                HttpCoreContext.HTTP_CONNECTION);
        if (conn == null) {
            this.logger.warning(
                ".keepAlive(...) called with empty context: " + context
                + " response was: " + response);
        } else {
            int status = response.getStatusLine().getStatusCode();
            conn.log(status);
            ((Logger) context.getAttribute(BaseAsyncServer.LOGGER))
                .fine("Request processed");
        }
        return super.keepAlive(response, context);
    }
}

