package ru.yandex.http.server.async;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;

import org.apache.http.config.ConnectionConfig;
import org.apache.http.nio.reactor.IOSession;

public class LoggingNHttpServerConnectionFactory
    extends NHttpServerConnectionFactory
{
    public LoggingNHttpServerConnectionFactory(
        final ConnectionConfig config,
        final ThreadPoolExecutor executor)
        throws IOException
    {
        super(config, executor);
    }

    @Override
    public LoggingNHttpServerConnection createConnection(
        final IOSession session)
    {
        ActiveConnection conn = (ActiveConnection) session.removeAttribute(
            IOSession.ATTACHMENT_KEY);
        return new LoggingNHttpServerConnection(
            new AsyncCloseableIOSession(
                session,
                conn,
                selectors[(int) (count.getAndIncrement() % selectors.length)],
                executor),
            config);
    }
}

