package ru.yandex.http.server.async;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;

import org.apache.http.config.ConnectionConfig;
import org.apache.http.nio.NHttpConnectionFactory;

public abstract class NHttpServerConnectionFactory
    implements NHttpConnectionFactory<LoggingNHttpServerConnection>
{
    protected final AtomicLong count = new AtomicLong();
    protected final ConnectionConfig config;
    protected final Executor executor;
    protected final Selector[] selectors;

    protected NHttpServerConnectionFactory(
        final ConnectionConfig config,
        final ThreadPoolExecutor executor)
        throws IOException
    {
        this.config = config;
        this.executor = executor;
        int size = executor.getCorePoolSize();
        selectors = new Selector[size];
        for (int i = 0; i < size; ++i) {
            selectors[i] = Selector.open();
        }
    }
}

