package ru.yandex.http.server.async;

import java.io.IOException;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.protocol.HttpContext;

import ru.yandex.compress.Deflater;
import ru.yandex.compress.GzipOutputStream;
import ru.yandex.http.util.HeaderUtils;
import ru.yandex.http.util.ResponseContentEncodingBase;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;

public class NResponseContentEncoding extends ResponseContentEncodingBase {
    private static final Header CONTENT_ENCODING =
        HeaderUtils.createHeader(HttpHeaders.CONTENT_ENCODING, "gzip");

    public NResponseContentEncoding(final boolean gzip, final int bufferSize) {
        super(gzip, bufferSize);
    }

    @Override
    public void process(final HttpResponse response, final HttpContext context)
        throws HttpException, IOException
    {
        if (gzip(response, context)) {
            HttpEntity entity = response.getEntity();
            if (entity instanceof NByteArrayEntity
                || entity instanceof NStringEntity)
            {
                DecodableByteArrayOutputStream out =
                    new DecodableByteArrayOutputStream();
                try (GzipOutputStream gzip = new GzipOutputStream(
                        out,
                        bufferSize,
                        false,
                        Deflater.BEST_SPEED))
                {
                    entity.writeTo(gzip);
                }
                NByteArrayEntity outEntity =
                    out.processWith(NByteArrayEntityFactory.INSTANCE);
                outEntity.setContentType(entity.getContentType());
                outEntity.setContentEncoding(CONTENT_ENCODING);
                response.setEntity(outEntity);
            }
        }
    }
}

