package ru.yandex.http.server.async;

import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.logger.PrefixedLogger;

public class PingHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpServer<?, ?> server;

    public PingHandler(final HttpServer<?, ?> server) {
        this.server = server;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
    {
        PrefixedLogger logger =
            (PrefixedLogger) context.getAttribute(HttpServer.LOGGER);
        if (server.pingEnabled(logger)) {
            exchange.getResponse().setEntity(
                new NStringEntity("pong", ContentType.TEXT_PLAIN));
        } else {
            exchange.getResponse().setStatusCode(
                HttpStatus.SC_SERVICE_UNAVAILABLE);
        }

        exchange.submitResponse();
    }

    @Override
    public String toString() {
        return "Simple ping-pong handler";
    }
}

