package ru.yandex.http.server.async;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;

import javax.net.ssl.SSLContext;

import org.apache.http.config.ConnectionConfig;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;

public class SSLLoggingNHttpServerConnectionFactory
    extends NHttpServerConnectionFactory
{
    private final SSLContext sslContext;
    private final SSLSetupHandler sslSetupHandler;

    // CSOFF: ParameterNumber
    public SSLLoggingNHttpServerConnectionFactory(
        final ConnectionConfig config,
        final ThreadPoolExecutor executor,
        final SSLContext sslContext,
        final SSLSetupHandler sslSetupHandler)
        throws IOException
    {
        super(config, executor);
        this.sslContext = sslContext;
        this.sslSetupHandler = sslSetupHandler;
    }
    // CSON: ParameterNumber

    @Override
    public LoggingNHttpServerConnection createConnection(
        final IOSession session)
    {
        ActiveConnection conn = (ActiveConnection) session.removeAttribute(
            IOSession.ATTACHMENT_KEY);
        SSLIOSession sslSession = new SSLIOSession(
            session,
            SSLMode.SERVER,
            sslContext,
            sslSetupHandler);
        session.setAttribute(SSLIOSession.SESSION_KEY, sslSession);
        return new LoggingNHttpServerConnection(
            new AsyncCloseableIOSession(
                sslSession,
                conn,
                selectors[(int) (count.getAndIncrement() % selectors.length)],
                executor),
            config);
    }
}

