package ru.yandex.http.server.async;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.charset.StreamEncoder;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.http.util.server.JsonStatsConsumer;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.ScanningCgiParams;
import ru.yandex.stater.Stater;

public class StatHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private final Stater stater;

    public StatHandler(final Stater stater) {
        this.stater = stater;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        Charset charset = CharsetUtils.acceptedCharset(request);
        CharsetEncoder encoder = charset.newEncoder()
            .onMalformedInput(CodingErrorAction.REPLACE)
            .onUnmappableCharacter(CodingErrorAction.REPLACE);
        DecodableByteArrayOutputStream baos =
            new DecodableByteArrayOutputStream();
        try (JsonWriter writer = JsonTypeExtractor.NORMAL
                .extract(new ScanningCgiParams(request))
                .create(new StreamEncoder(baos, encoder));
            JsonStatsConsumer statsConsumer = new JsonStatsConsumer(writer))
        {
            stater.stats(statsConsumer);
        }
        exchange.getResponse().setEntity(
            baos.processWith(
                new NByteArrayEntityFactory(
                    ContentType.APPLICATION_JSON.withCharset(charset))));
        exchange.submitResponse();
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public String toString() {
        return "Prints server status in golovan format.";
    }
}

