package ru.yandex.http.server.async;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.charset.StreamEncoder;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.CgiParams;

public class StatusHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpServer<?, HttpAsyncRequestHandler<?>> server;

    public StatusHandler(
        final HttpServer<?, HttpAsyncRequestHandler<?>> server)
    {
        this.server = server;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        CgiParams params = new CgiParams(request);
        Charset charset = CharsetUtils.acceptedCharset(request);
        CharsetEncoder encoder = charset.newEncoder()
            .onMalformedInput(CodingErrorAction.REPLACE)
            .onUnmappableCharacter(CodingErrorAction.REPLACE);
        DecodableByteArrayOutputStream baos =
            new DecodableByteArrayOutputStream();
        try (JsonWriter writer = JsonTypeExtractor.HUMAN_READABLE
                .extract(params)
                .create(new StreamEncoder(baos, encoder)))
        {
            writer.value(server.status(params.getBoolean("verbose", true)));
        }
        exchange.getResponse().setEntity(
            baos.processWith(
                new NByteArrayEntityFactory(
                    ContentType.APPLICATION_JSON.withCharset(charset))));
        exchange.submitResponse();
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public String toString() {
        return
            "Prints server status: amount of active workers, connections etc.";
    }
}

