package ru.yandex.http.server.async;

import java.util.Timer;
import java.util.TimerTask;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.ScanningCgiParams;

public class SystemExitHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private static final int DEFAULT_EXIT_DELAY = 10000;
    private static final int SEC_MILLIS = 1000;

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ScanningCgiParams cgiParams = new ScanningCgiParams(request);
        if (!cgiParams.getString("password").equals("yes_i_want_this_ugu")) {
            throw new BadRequestException("Authentification failed");
        }
        final int delay = cgiParams.getInt("delay", DEFAULT_EXIT_DELAY);
        new Timer().schedule(
            new ExitTask(cgiParams.getInt("code", 1)),
            delay);
        final int secs = delay / SEC_MILLIS;
        exchange.getResponse().setEntity(
            new NStringEntity(
                "exiting in " + secs + " secs...", ContentType.TEXT_PLAIN));
        exchange.submitResponse();
    }

    @Override
    public String toString() {
        return "Shutdown server";
    }

    private static class ExitTask extends TimerTask {
        private final int code;

        ExitTask(final int code) {
            this.code = code;
        }

        @Override
        public void run() {
            System.exit(code);
        }
    }
}

