package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractClientHttpsConfigBuilder
    <T extends AbstractClientHttpsConfigBuilder<T>>
    extends AbstractHttpsConfigBuilder<T>
    implements ClientHttpsConfig
{
    private boolean verifyCertificate;
    private boolean verifyHostname;
    private String trustManagerAlgorithm;

    protected AbstractClientHttpsConfigBuilder(final ClientHttpsConfig config) {
        super(config);
        verifyCertificate(config.verifyCertificate());
        verifyHostname(config.verifyHostname());
        trustManagerAlgorithm(config.trustManagerAlgorithm());
    }

    protected AbstractClientHttpsConfigBuilder(
        final IniConfig config,
        final ClientHttpsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        verifyCertificate =
            VERIFY_CERTIFICATE.extract(config, defaults.verifyCertificate());
        verifyHostname =
            VERIFY_HOSTNAME.extract(config, defaults.verifyHostname());
        trustManagerAlgorithm = TRUST_MANAGER_ALGORITHM.extract(
            config,
            defaults.trustManagerAlgorithm());
    }

    @Override
    public boolean verifyCertificate() {
        return verifyCertificate;
    }

    public T verifyCertificate(final boolean verifyCertificate) {
        this.verifyCertificate = verifyCertificate;
        return self();
    }

    @Override
    public boolean verifyHostname() {
        return verifyHostname;
    }

    public T verifyHostname(final boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
        return self();
    }

    @Override
    public String trustManagerAlgorithm() {
        return trustManagerAlgorithm;
    }

    public T trustManagerAlgorithm(final String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
        return self();
    }
}

