package ru.yandex.http.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractDnsConfigBuilder
    <T extends AbstractDnsConfigBuilder<T>>
    implements ConfigBuilder<T>, DnsConfig
{
    private long dnsTtl;
    private long dnsUpdateInterval;
    private Map<String, String> dnsHostsMapping;

    protected AbstractDnsConfigBuilder(final DnsConfig config) {
        dnsTtl(config.dnsTtl());
        dnsUpdateInterval(config.dnsUpdateInterval());
        dnsHostsMapping(config.dnsHostsMapping());
    }

    protected AbstractDnsConfigBuilder(
        final IniConfig config,
        final DnsConfig defaults)
        throws ConfigException
    {
        dnsTtl = DNS_TTL.extract(config, defaults.dnsTtl());
        dnsUpdateInterval =
            DNS_UPDATE_INTERVAL.extract(config, defaults.dnsUpdateInterval());
        IniConfig mapping = config.sectionOrNull("dns-hosts-mapping");
        if (mapping == null) {
            dnsHostsMapping(defaults.dnsHostsMapping());
        } else {
            Set<String> keys = mapping.keys();
            dnsHostsMapping = new HashMap<>(keys.size() << 1);
            for (String host: keys) {
                dnsHostsMapping.put(host, mapping.getString(host));
            }
        }
    }

    @Override
    public long dnsTtl() {
        return dnsTtl;
    }

    public T dnsTtl(final long dnsTtl) {
        this.dnsTtl = dnsTtl;
        return self();
    }

    @Override
    public long dnsUpdateInterval() {
        return dnsUpdateInterval;
    }

    public T dnsUpdateInterval(final long dnsUpdateInterval) {
        this.dnsUpdateInterval = dnsUpdateInterval;
        return self();
    }

    @Override
    public Map<String, String> dnsHostsMapping() {
        return dnsHostsMapping;
    }

    public T dnsHostsMapping(final Map<String, String> dnsHostsMapping) {
        this.dnsHostsMapping = new HashMap<>(dnsHostsMapping);
        return self();
    }
}

