package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractExternalDataConfigBuilder
    <T extends AbstractExternalDataConfigBuilder<T>>
    extends AbstractURIConfigBuilder<T>
    implements ExternalDataConfig
{
    private long updateInterval;

    protected AbstractExternalDataConfigBuilder(
        final ExternalDataConfig config)
    {
        super(config);
        updateInterval(config.updateInterval());
    }

    protected AbstractExternalDataConfigBuilder(
        final IniConfig config,
        final ExternalDataConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        updateInterval =
            UPDATE_INTERVAL.extract(config, defaults.updateInterval());
    }

    @Override
    public long updateInterval() {
        return updateInterval;
    }

    public T updateInterval(final long updateInterval) {
        this.updateInterval = updateInterval;
        return self();
    }

    public void copyTo(final AbstractExternalDataConfigBuilder<?> other) {
        copyTo((AbstractURIConfigBuilder<?>) other);
        other.updateInterval(updateInterval());
    }
}

