package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.PositiveIntegerValidator;

public abstract class AbstractFilterSearchConfigBuilder
    <T extends AbstractFilterSearchConfigBuilder<T>>
    extends AbstractURIConfigBuilder<T>
    implements FilterSearchConfig
{
    private int batchSize;

    protected AbstractFilterSearchConfigBuilder(final FilterSearchConfig config) {
        super(config);
        batchSize = config.batchSize();
    }

    protected AbstractFilterSearchConfigBuilder(
        final IniConfig config,
        final FilterSearchConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        batchSize = config.get(
            "batch-size",
            defaults.batchSize(),
            PositiveIntegerValidator.INSTANCE);
    }

    @Override
    public int batchSize() {
        return batchSize;
    }

    public T batchSize(final int batchSize) {
        this.batchSize = batchSize;
        return self();
    }
}
