package ru.yandex.http.config;

import org.apache.http.HttpHost;

import ru.yandex.http.util.HttpHostParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveIntegerValidator;

public abstract class AbstractHttpHostConfigBuilder
    <T extends AbstractHttpHostConfigBuilder<T>>
    extends AbstractHttpTargetConfigBuilder<T>
    implements HttpHostConfig
{
    private static final String HOST = "host";

    private HttpHost host;

    protected AbstractHttpHostConfigBuilder(final HttpHostConfig config) {
        super(config);
        this.host = config.host();
    }

    protected AbstractHttpHostConfigBuilder(
        final IniConfig config,
        final HttpHostConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        Integer port =
            config.get("port", null, PositiveIntegerValidator.INSTANCE);
        if (port == null) {
            host = config.get(HOST, defaults.host(), HttpHostParser.INSTANCE);
        } else {
            host = new HttpHost(
                config.get(HOST, NonEmptyValidator.INSTANCE),
                port);
        }
    }

    @Override
    public HttpHost host() {
        return host;
    }

    public T host(final HttpHost host) {
        this.host = host;
        return self();
    }

    public void copyTo(final AbstractHttpHostConfigBuilder<?> other) {
        copyTo((AbstractHttpTargetConfigBuilder<?>) other);
        other.host(host());
    }
}

