package ru.yandex.http.config;

import java.util.List;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractHttpsConfigBuilder
    <T extends AbstractHttpsConfigBuilder<T>>
    implements ConfigBuilder<T>, HttpsConfig
{
    private String protocol;
    private List<String> enabledProtocols;
    private String jsseProvider;
    private String secureRandomAlgorithm;
    private String secureRandomProvider;
    private KeyStoreConfigBuilder keyStoreConfig;

    protected AbstractHttpsConfigBuilder(final HttpsConfig config) {
        protocol(config.protocol());
        jsseProvider(config.jsseProvider());
        secureRandomAlgorithm(config.secureRandomAlgorithm());
        secureRandomProvider(config.secureRandomProvider());
        enabledProtocols(config.enabledProtocols());
        keyStoreConfig(config.keyStoreConfig());
    }

    protected AbstractHttpsConfigBuilder(
        final IniConfig config,
        final HttpsConfig defaults)
        throws ConfigException
    {
        protocol = PROTOCOL.extract(config, defaults.protocol());
        enabledProtocols =
            ENABLED_PROTOCOLS.extract(config, defaults.enabledProtocols());
        jsseProvider =
            JSSE_PROVIDER.extract(config, defaults.jsseProvider());
        secureRandomAlgorithm = SECURE_RANDOM_ALGORITHM.extract(
            config,
            defaults.secureRandomAlgorithm());
        secureRandomProvider = SECURE_RANDOM_PROVIDER.extract(
            config,
            defaults.secureRandomProvider());
        keyStoreConfig =
            KEY_STORE_CONFIG.extract(config, defaults.keyStoreConfig());
    }

    @Override
    public String protocol() {
        return protocol;
    }

    public T protocol(final String protocol) {
        this.protocol = protocol;
        return self();
    }

    @Override
    public List<String> enabledProtocols() {
        return enabledProtocols;
    }

    public T enabledProtocols(final List<String> enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return self();
    }

    @Override
    public String jsseProvider() {
        return jsseProvider;
    }

    public T jsseProvider(final String jsseProvider) {
        this.jsseProvider = jsseProvider;
        return self();
    }

    @Override
    public String secureRandomAlgorithm() {
        return secureRandomAlgorithm;
    }

    public T secureRandomAlgorithm(final String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
        return self();
    }

    @Override
    public String secureRandomProvider() {
        return secureRandomProvider;
    }

    public T secureRandomProvider(final String secureRandomProvider) {
        this.secureRandomProvider = secureRandomProvider;
        return self();
    }

    @Override
    public KeyStoreConfigBuilder keyStoreConfig() {
        return keyStoreConfig;
    }

    public T keyStoreConfig(final KeyStoreConfig keyStoreConfig) {
        if (keyStoreConfig == null) {
            this.keyStoreConfig = null;
        } else {
            this.keyStoreConfig = new KeyStoreConfigBuilder(keyStoreConfig);
        }
        return self();
    }
}

