package ru.yandex.http.config;

import java.net.URL;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractKeyStoreConfigBuilder
    <T extends AbstractKeyStoreConfigBuilder<T>>
    implements ConfigBuilder<T>, KeyStoreConfig
{
    private URL file;
    private String type;
    private String password;

    protected AbstractKeyStoreConfigBuilder(final KeyStoreConfig config) {
        file(config.file());
        type(config.type());
        password(config.password());
    }

    protected AbstractKeyStoreConfigBuilder(
        final IniConfig config,
        final KeyStoreConfig defaults)
        throws ConfigException
    {
        file = FILE.extract(config, defaults.file());
        type = TYPE.extract(config, defaults.type());
        password = PASSWORD.extract(config, defaults.password());
    }

    @Override
    public URL file() {
        return file;
    }

    public T file(final URL file) {
        this.file = file;
        return self();
    }

    @Override
    public String type() {
        return type;
    }

    public T type(final String type) {
        this.type = type;
        return self();
    }

    @Override
    public String password() {
        return password;
    }

    public T password(final String password) {
        this.password = password;
        return self();
    }
}

