package ru.yandex.http.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractServerHttpsConfigBuilder
    <T extends AbstractServerHttpsConfigBuilder<T>>
    extends AbstractHttpsConfigBuilder<T>
    implements ServerHttpsConfig
{
    private String aliasPassword;
    private int httpPort;
    private String keyManagerAlgorithm;

    protected AbstractServerHttpsConfigBuilder(final ServerHttpsConfig config) {
        super(config);
        aliasPassword(config.aliasPassword());
        httpPort(config.httpPort());
        keyManagerAlgorithm(config.keyManagerAlgorithm());
    }

    protected AbstractServerHttpsConfigBuilder(
        final IniConfig config,
        final ServerHttpsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        aliasPassword =
            ALIAS_PASSWORD.extract(config, defaults.aliasPassword());
        httpPort = HTTP_PORT.extract(config, defaults.httpPort());
        keyManagerAlgorithm = KEY_MANAGER_ALGORITHM.extract(
            config,
            defaults.keyManagerAlgorithm());
    }

    @Override
    public String aliasPassword() {
        return aliasPassword;
    }

    public T aliasPassword(final String aliasPassword) {
        this.aliasPassword = aliasPassword;
        return self();
    }

    @Override
    public int httpPort() {
        return httpPort;
    }

    public T httpPort(final int httpPort) {
        this.httpPort = httpPort;
        return self();
    }

    @Override
    public String keyManagerAlgorithm() {
        return keyManagerAlgorithm;
    }

    public T keyManagerAlgorithm(final String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm;
        return self();
    }
}

